;HERO VARIABLES
HERO_IDLE=0
HERO_MOVE_RIGHT=1
HERO_MOVE_LEFT=2
HERO_MOVE_UP=3
HERO_MOVE_DOWN=4
HERO_FALL=5

FACE_RIGHT=1
FACE_LEFT=2

DIR_NULL=0
DIR_UP=1
DIR_DOWN=2




resetHero:
	xor a : ld (heroState),a : ld (heroPreState),a : ld (idleDirection),a: ld (blockTick),a
	ld (heroGold),a : ld (heroPickaxe),a : ld (heroDelay),a : ld (heroMoveCount),a
	ld hl,00000 : ld (heroCellPosition),hl : ld (heroPosition),hl
	ld a,FACE_RIGHT : ld (heroFaceDirection),a
	ld a,8 : ld (pushDelay),a
	
	//apply hero position to sprite0
    //ld a,(heroPosition) : ld (spritesTable+1),a;y
    //ld a,(heroPosition+1) : ld (spritesTable),a;x
	ld a,15 : ld (spritesTable+3),a

	ret

doHero:    
	ld a,(heroState)
	ld (heroPreState),a

	;process hero blocks
	call processBlock

	;controls and physic
	call calcHeroSprite		
	ld a,(currentLevel)
	cp 21
	call c,heroControls		
	call doHeroMove

	call doHeroSounds

	ld b,3
	ld ix,enemiesList
	ld de,16
1:
	call checkEnemy
	add ix,de
	djnz 1b

    ret

checkEnemy:
	;if we blink - not kill
	ld a,(ix+7)
	cp 33
    ret nc
;X
	ld a,(heroPosition)        ; player's x coordinate.
	sub (ix+1)          ; subtract alien x.
	add a,3             ; player is 3 high, so add 3 - 1 = 2.
	cp 6                ; combined heights are 3 + 2 = 5.
    ret nc              ; not within vertical range.	

	;Y
	ld a,(heroPosition+1)        ; player's y coordinate.
    sub (ix+2)          ; subtract alien y.
    add a,4             ; player is 3 wide, so add 3 - 1 = 2.
    cp 6                ; combined widths are 3 + 4 = 7.
    ret nc              ; not within horizontal range.
    ;jp collis           ; we have a collision.

	;kill hero
	call killHero

	ret

checkFireButton:	  
	
	ld a,#08
	;SPACE
	call SNSMAT 
    bit 0,a
    ret z	

	ld a,(joyStatus)
	bit 4,a
	ret z
	bit 5,a
	ret z


    ret

doBlock:
	;check if was fire button up
	ld a,(wasFireUp)
	or a
	ret z
	
	ld a,(heroState)
	cp HERO_IDLE
	ret nz

	;reset fireup state to fire pushed
	xor a : ld (wasFireUp),a

	;reset push delay
	ld a,4 : ld (pushDelay),a

	;pause hero
	ld a,8 : ld (heroMoveCount),a
	ld a,HERO_IDLE : ld (heroState),a

	ld de,(heroPosition)
	call getTileCoords
	inc d

	;not dig under ladder
	ld a,(hl): cp TILE_LADDER : jp z,1f

	ld bc,32 : add hl,bc : ld a,(hl)	
	;no free space check if block to remove
	cp TILE_SOLID+1
	jr nz,1f
	
	;check if we have pickaxe
	ld a,(heroPickaxe)
	or a
	ret z
	exx : call subPickaxe : exx

	ld (hl),0 : jp hideBlock

1:

;bridge checks
	cp TILE_LEFT
	jr z,4f
	cp TILE_RIGHT
	ret nz
	ld a,FACE_RIGHT : ld (bridgeFace),a
	ex af,af :	ld a,TILE_ANTIRIGHT;disable arrow
	ld (hl),a;TILE_ANTILEFT;disable arrow
	ex af,af
	jr 5f
4:
	ld a,FACE_LEFT : ld (bridgeFace),a
	ex af,af : ld a,TILE_ANTILEFT;disable arrow
	ld (hl),a;TILE_ANTILEFT;disable arrow
	ex af,af
5:
	;add TILE_ANTILEFT-1
	
	ld a,8 : ld (heroMoveCount),a : call playMostSound	
	ld de,(heroPosition)
	call getTileCoords : inc d
	ld bc,32 : add hl,bc
	push de : push hl
	ex af,af :  call fillTile : ex af,af

	pop hl : pop de
	
	ld a,(bridgeFace)
	jp initBridge


	ret


heroControls:

    ld a,(gameState)
	cp GS_GAMEPLAY
	ret nz

    call moveControls    


	ld a,(heroState)
	cp HERO_IDLE
	ret nz

	ld de,(heroPosition)
	call getTile
	ld bc,32 : add hl,bc
	ld a,(hl)
	cp TILE_SOLID+1
	ret c
	

;put block only if idle mode	  
;return 1 if pressed fire
	  ld a,(pushDelay)
	  or a
	  jr z,2f
	  dec a
	  ld (pushDelay),a
	  jr 1f
2:	  
	  ;ld de,(heroPosition) : inc e : ld (heroPosition),de
	  call checkFireButton
	  jp z,doBlock
	  ;ok, not fire pressed - set a fire up flag
	  ld a,1 : ld (wasFireUp),a
1: 


    ret



//check falling down
checkFall:
	;check fi we on ladder
	ld de,(heroPosition)	
	call getTile
	cp TILE_LADDER : ret z

	;check tile under hero
	ld de,(heroPosition)	
	ld a,d : add 8 : ld d,a
	call getTile

	cp TILE_MINE
	jr nz,1f
	push af

	ld (hl),TILE_ACTIVEMINE
	ld de,(heroPosition)	
	call getTileCoords : inc d
	ld bc,32 : add hl,bc
	push de : call addMine : pop de	

	pop af
1:

	cp TILE_SOLID :  ret nc
	
	ld a,HERO_FALL : ld (heroState),a	: ld a,4 : ld (heroMoveCount),a	
	ret

collectGold:	
	ld (hl),0
	ld de,(heroPosition)
    xor a : call fillTileXY
	;call getTileCoordsDown : ld a,0
	;ld (topTile1+1),a : ld (topTile1Coords+1),de
	call playCollectSound2
	call addGold
	xor a;reset tile
	ret

collectPickaxe:
	ld (hl),0
	ld de,(heroPosition)
    xor a : call fillTileXY
	;call getTileCoordsDown : ld a,0
	;ld (topTile1+1),a : ld (topTile1Coords+1),de
	call playCollectSound
	call addPickaxe
	xor a;reset tile
	ret

heroWin:	
	ld a,(gameState) : cp GS_GAMEPLAY : ret nz
	ld a,GS_STAGECLEAR : ld (gameState),a	
	call muteMusic
	ret

teleportHero:	
	ld a,13 : ld (heroPosition+1),a
	ld a,8
	;ld a,12: call AFXPLAY
	di : ld a,12 : ld c,0 : call ayFX_INIT : ei;15-low 0 -high
	ret

killHero:	
	ld a,GS_DEAD : ld (gameState),a
	call muteMusic	
	ret

endMove:
	;check dead on fire and pike
	ld de,(heroPosition)
	call getTile
	cp TILE_TELEPORT
	jp z,teleportHero
	cp TILE_FIRE
	jp z,killHero
	cp TILE_PIKE
	jp z,killHero

	;set idle state
	ld a,HERO_IDLE
	ld (heroState),a
	;check end of level
	ld a,(heroGold)	
	ld bc,(totalGold)
	cp c
	jp z,heroWin
	;check for falling
	call checkFall	
	ret

doHeroMove:
	ld a,(heroMoveCount)
	or a
	jr z,endMove	
	dec a
	ld (heroMoveCount),a	

	cp 0
	jr nz,1f
	ld de,(heroPosition)	
	call getTile	
	CP TILE_GOLD
	call z,collectGold	
	CP TILE_PICKAXE
	call z,collectPickaxe	
	jr 2f
1:
	;on step 42 check collect
	cp 2
	jr nz,2f
	ld de,(heroPosition)	
	call getTile
	CP TILE_GOLD
	call z,collectGold	
	CP TILE_PICKAXE
	call z,collectPickaxe	
2:




//move
	ld a,(heroState)
	cp HERO_MOVE_RIGHT
	jp z,moveHeroRight
	cp HERO_MOVE_LEFT
	jp z,moveHeroLeft
	cp HERO_MOVE_UP
	jp z,moveHeroUp
	cp HERO_MOVE_DOWN
	jp z,moveHeroDown
	cp HERO_FALL
	jp z,fallHero

	ret

moveHeroUp:
	ld a,(heroPosition+1)
	dec a
	ld (heroPosition+1),a
	ret
moveHeroDown:
	ld a,(heroPosition+1)
	inc a
	ld (heroPosition+1),a
	ret
fallHero:
	ld a,(heroPosition+1)
	inc a:inc a
	ld (heroPosition+1),a
	ret
moveHeroRight:
	ld a,(heroPosition)
	inc a
	ld (heroPosition),a
	ret
moveHeroLeft:
	ld a,(heroPosition)
	dec a
	ld (heroPosition),a
	ret




moveControls:

	  ld a,(heroMoveCount)
	  or a
	  ret nz	  	

	  ;reset last dir
	  xor a : ld (lastDir),a


    ;ROW 8 - 7,6,5,4,3,2,1,0
    ;        r,d,u,l       space
    ld a,#08    ;; get the status of the 8th keyboard row (to get SPACE and arrow keys)
    call SNSMAT 
    bit 7,a
    jp z,tryMoveRight
    bit 6,a
    jp z,tryMoveDown
    bit 5,a
    jp z,tryMoveUp
    bit 4,a
    jp z,tryMoveLeft

	;call readJoystick1Status	
	ld a,(joyStatus)
	bit 0,a
	jp z,tryMoveUp
	bit 1,a
	jp z,tryMoveDown
	bit 2,a
	jp z,tryMoveLeft
	bit 3,a
	jp z,tryMoveRight

    ld a,HERO_IDLE
    ld (heroState),a

    ret

readJoystick1Status:
    ld a,15 ; read the joystick 1 status:
;    di      ; in XSpelunky I found that in one instance, the interrupt was comming WHILE inside of a RDPSG call, messing things up!
    call RDPSG
;    ei
    and #bf
    ld e,a
    ld a,15
    call WRTPSG
    dec a
;    di      ; in XSpelunky I found that in one instance, the interrupt was comming WHILE inside of a RDPSG call, messing things up!
    call RDPSG
;    ei
    ;cpl ; invert the bits (so that '1' means direction pressed)

	;check directions
	ld (joyStatus),a

    ret


tryMoveRight:
    ;idle direction for correct idle animation
	ld a,0 : ld (idleDirection),a
	;set face direction
	ld a,FACE_RIGHT : ld (heroFaceDirection),a

	;if we don't stand - ret
   	ld a,(heroState)
	cp HERO_IDLE
	ret nz
	;change hero sprite
	;ld hl,heroRight : ld (heroSprite+1),hl

	;check collisions
	ld de,(heroPosition)
	ld a,e : add 4 : ld e,a
	call getTile	

	;if not solid blocks then move
	cp TILE_SOLID
	ret nc

	;chenge hero state
	ld a,HERO_MOVE_RIGHT : ld (heroState),a	: ld a,8 : ld (heroMoveCount),a		
    ret

tryMoveLeft:
    ;idle direction for correct idle animation
	ld a,8 : ld (idleDirection),a
	
	;set face direction
	ld a,FACE_LEFT : ld (heroFaceDirection),a

	;if we don't stand - ret
   	ld a,(heroState)
	cp HERO_IDLE
	ret nz
	;change hero sprite
	;ld hl,heroLeft : ld (heroSprite+1),hl

	;check collisions
	ld de,(heroPosition)
	ld a,e : sub 8+4 : ld e,a
	call getTile	
	
	;if not solid blocks then move
	cp TILE_SOLID
	ret nc
	
	;chenge hero state
	ld a,HERO_MOVE_LEFT : ld (heroState),a	: ld a,8 : ld (heroMoveCount),a		

    ret

tryMoveUp:
    
	;write last dir
	ld a,DIR_UP : ld (lastDir),a

	;if we don't stand - ret
   	ld a,(heroState)
	cp HERO_IDLE
	ret nz

	;check if there is a ladder	
	ld de,(heroPosition)
	;ld a,d : sub 8 : ld e,d
	call getTile		

	cp TILE_LADDER : ret nz

	;is there solid above head&
	ld bc,-32:add hl,bc ;up not solid
	ld a,(hl)
	
	;if not solid blocks then move
	cp TILE_SOLID
	ret nc

	cp TILE_LADDER
	ret nz

	;change hero sprite
	;ld hl,heroLadder : ld (heroSprite+1),hl

	;chenge hero state
	ld a,HERO_MOVE_UP : ld (heroState),a	: ld a,8 : ld (heroMoveCount),a	

    ret

tryMoveDown:
    	;if we don't stand - ret
   	ld a,(heroState)
	cp HERO_IDLE
	ret nz

	;write last dir
	ld a,DIR_DOWN : ld (lastDir),a

	;check if there is a ladder	down
	ld de,(heroPosition)
	ld a,d : add 8 : ld d,a
	call getTile	

	or a: jr z,1f

	;check bridge, jump from bridge	
	cp TILE_BRIDGE : jr z,2f
	cp TILE_BRIDGE1 : jr z,2f
	cp TILE_BRIDGE2 : jr z,2f

	 ;jump from ladder
	cp TILE_LADDER : ret nz
1:
	;change hero sprite
	;ld hl,heroLadder : ld (heroSprite+1),hl
	;chenge hero state
	ld a,HERO_MOVE_DOWN : ld (heroState),a	: ld a,8 : ld (heroMoveCount),a	
	ret
	;fall from bridge
2:
	ld a,HERO_FALL : ld (heroState),a	: ld a,8 : ld (heroMoveCount),a	
    ret


//calculate hero sprite addr by hero state
calcHeroSprite:
    //apply hero position to sprite0
    ld a,(heroPosition) : ld (spritesTable+1),a;y
    ld a,(heroPosition+1) : ld (spritesTable),a;x

	//update a basic idle and fall animations
	call doBasicAnimations

	ld a,(heroState)            
	or a
	jp z,calcHeroSpriteIdle

	cp HERO_FALL: jp z,calcHeroSpriteFall    
	cp HERO_MOVE_UP: jp z,calcHeroSpriteLadder
	cp HERO_MOVE_DOWN: jp z,calcHeroSpriteLadder
	
	;ok standart moving
calcHeroSpriteMoving:
    ;walk animation is 8-15 - right and 16-23 - left
    ld c,8
    CP HERO_MOVE_LEFT
    jr nz,1f
    ld c,0
1:
    ;ok - frame is movecount
    ld a,(heroMoveCount)
    add c
    add 8

    ;every frame is from 4 cells
    add a,a : add a,a
    ld (spritesTable+2),a
	ret


calcHeroSpriteIdle:

	ld de,(heroPosition)	
	call getTile
	cp TILE_LADDER
	ret z

    ;get idle animation calculated in basic animation and put to sprite 0 - hero sprite
    ld a,(basicHeroTick)      
    ;idle animation is 0,1 - right and 2,3 - left

    ;every frame is from 4 cells
    add a,a : add a,a
    ld c,a : ld a,(idleDirection) : add c
    ld (spritesTable+2),a
	ret

calcHeroSpriteFall:		
    ld a,(basicHeroTick)      
    ;fall animation is 6,7
    add 6
    ;every frame is from 4 cells
    add a,a : add a,a
	ld (spritesTable+2),a
	ret


calcHeroSpriteLadder:
    ld a,(basicHeroTick)      
    ;ladder animation is 4,5
    add 4
    ;every frame is from 4 cells
    add a,a : add a,a
	ld (spritesTable+2),a
	ret
/*
calcHeroAddr:
	ld bc,(heroPosition)
	call getScreenAddr
	ld (sprites+2),hl
	ret
*/

//Process basic animations deltas
doBasicAnimations:
//DELAY
	ld a,(basicHeroAnimationDelay)
	inc a
	and 7
	ld (basicHeroAnimationDelay),a
	or a
	ret nz
        ;tick for basic animations
    	ld a,(basicHeroTick)
		inc a : and 1
		ld (basicHeroTick),a
	ret


;=============== BLOCK ==================

//Process show|hide block animation
processBlock:
	ld a,(blockTick)
	or a
	ret z
	dec a
	ld (blockTick),a
	
	;delay
	ld a,(blockDelay)
	inc a: and 1
	ld (blockDelay),a
	or a
	ret z

	ld a,(blockFrame)
	dec a
	ld (blockFrame),a
    ld de,(blockCoords)
	;patch up draw
	call fillTile
	ret

hideBlock
	;xor a: call fillTile
	ld a,16
	ld (blockFrame),a
	ld a,8 : ld (blockTick),a
	ld (blockCoords),de
	call playHideBlockSound
	ret
